import time
import board
import digitalio
import usb_hid
from adafruit_hid.keyboard import Keyboard
from adafruit_hid.keycode import Keycode

kbd = Keyboard(usb_hid.devices)

button_s = digitalio.DigitalInOut(board.GP14)
button_s.direction = digitalio.Direction.INPUT
button_s.pull = digitalio.Pull.UP

button_a = digitalio.DigitalInOut(board.GP15)
button_a.direction = digitalio.Direction.INPUT
button_a.pull = digitalio.Pull.UP

prev_s = True
prev_a = True

while True:
    curr_s = button_s.value
    curr_a = button_a.value

    # Налаштування кнопок. Наприклад якщо потрібна кнопка Q замість S: міняємо обидва Keycode.S на Keycode.Q

    if not curr_s and prev_s:
        kbd.press(Keycode.S)
    elif curr_s and not prev_s:
        kbd.release(Keycode.S)

    if not curr_a and prev_a:
        kbd.press(Keycode.A)
    elif curr_a and not prev_a:
        kbd.release(Keycode.A)

    prev_s = curr_s
    prev_a = curr_a

    time.sleep(0.01)
